// *************************************************************
//   Created with BCX -- The BASIC To C Translator (ver 5.06.194)
//  BCX (c) 1999, 2000, 2001, 2002, 2003, 2004, 2005 by Kevin Diggins
// *************************************************************
//     Translated for compiling with a C Compiler
// *************************************************************
#include <windows.h>    // Win32 Header File 
#include <windowsx.h>   // Win32 Header File 
#include <commctrl.h>   // Win32 Header File 
#include <mmsystem.h>   // Win32 Header File 
#include <shellapi.h>   // Win32 Header File 
#include <shlobj.h>     // Win32 Header File 
#include <richedit.h>   // Win32 Header File 
#include <wchar.h>      // Win32 Header File 
#include <objbase.h>    // Win32 Header File 
#include <ocidl.h>      // Win32 Header File 
#include <winuser.h>    // Win32 Header File 
#include <olectl.h>     // Win32 Header File 
#include <oaidl.h>      // Win32 Header File 
#include <ole2.h>       // Win32 Header File 
#include <oleauto.h>    // Win32 Header File 
#include <conio.h>
#include <direct.h>
#include <ctype.h>
#include <io.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include <setjmp.h>
#include <time.h>
#include <stdarg.h>
#include <process.h>


// ***************************************************
// Compiler Defines
// ***************************************************

// C++
#if defined( __cplusplus )
  #define overloaded
  #define C_EXPORT EXTERN_C __declspec(dllexport)
  #define C_IMPORT EXTERN_C __declspec(dllimport)
#else
  #define C_EXPORT __declspec(dllexport)
  #define C_IMPORT __declspec(dllimport)
#endif

// Open Watcom defs
#if defined( __WATCOM_CPLUSPLUS__ )
  #define atanl atan
  #define sinl  sin
  #define cosl  cos
  #define tanl  tan
  #define asinl asin
  #define acosl acos
  #define log10l log10
  #define logl   log
  #define _fcloseall fcloseall
#endif

// Borland C++ 5.5.1 defs - bcc32.exe
#if defined( __BCPLUSPLUS__ )
  // ===== Borland Libraries ==========
  #include <dos.h>
  #pragma comment(lib,"import32.lib")
  #pragma comment(lib,"cw32.lib")
  // ==================================
#endif

// Microsoft VC++
#ifndef DECLSPEC_UUID
  #if (_MSC_VER >= 1100) && defined ( __cplusplus )
    #define DECLSPEC_UUID(x)    __declspec(uuid(x))
  #else
    #define DECLSPEC_UUID(x)
  #endif
#endif

#include <tchar.h>
#include <wizard.h>
#include "bcxwizard.h"
// ***************************************************

#define NELEMS(a)  (sizeof(a) / sizeof(a[0]))
#define enum_WizAction enum WizAction


#if !defined( __LCC__ )
// *************************************************
// Instruct Linker to Search Object/Import Libraries
// *************************************************
#pragma comment(lib,"kernel32.lib")
#pragma comment(lib,"user32.lib")
#pragma comment(lib,"gdi32.lib")
#pragma comment(lib,"comctl32.lib")
#pragma comment(lib,"advapi32.lib")
#pragma comment(lib,"winspool.lib")
#pragma comment(lib,"shell32.lib")
#pragma comment(lib,"ole32.lib")
#pragma comment(lib,"oleaut32.lib")
#pragma comment(lib,"uuid.lib")
#pragma comment(lib,"odbc32.lib")
#pragma comment(lib,"odbccp32.lib")
#pragma comment(lib,"winmm.lib")
#pragma comment(lib,"comdlg32.lib")
#pragma comment(lib,"imagehlp.lib")
#pragma comment(lib,"version.lib")
#else
#pragma lib <winspool.lib>
#pragma lib <shell32.lib>
#pragma lib <ole32.lib>
#pragma lib <oleaut32.lib>
#pragma lib <uuid.lib>
#pragma lib <odbc32.lib>
#pragma lib <odbccp32.lib>
#pragma lib <winmm.lib>
#pragma lib <imagehlp.lib>
#pragma lib <version.lib>
// *************************************************
// End of Object/Import Libraries To Search
// *************************************************
#endif
// *************************************************
//            User Defined Constants
// *************************************************

#define DLLNAME "BCX Wizard"
#define MB_TYPE MB_OK  BOR MB_ICONERROR  BOR MB_APPLMODAL  BOR MB_TOPMOST 
#define FILESET_CLASS struct _FILESET*

// *************************************************
//          User Defined Types And Unions
// *************************************************

typedef struct _fileset
{
char*  pszFile;
WORD  IDR_FILE;
BOOL  bText;
int  eProject;
}fileset, *LPFILESET;


// *************************************************
//                System Variables
// *************************************************


// *************************************************
//            User Global Variables
// *************************************************

static char    g_szProjname[2048];
static char    g_szDispname[2048];
static int     g_fType;
static int     cchProjname;
static BOOL   bcxfileopen;



// *************************************************
//               Standard Macros
// *************************************************

#define BOR |


// *************************************************
//               Standard Prototypes
// *************************************************

int     str_cmp(char*, char*);
char*   BCX_TmpStr(size_t);
char*   lcase (char*);
char*   mid (char*, int, int=-1);
char*   left (char*,int);
char*   extract (char*,char*);
char*   remain (char*,char*);
char*   replace (char*,char*,char*);
char*   PellesPath (void);
char*   RegString (HKEY,char*,char*);
char*   join (int, ... );
char*   chr(int,int=0,int=0,int=0,int=0,int=0,int=0,int=0,int=0,int=0);
int     InstrRev (char*,char*,int=0);
int     instr(char*,char*,int=0,int=0);
char    *_stristr_(char*,char*);
BOOL    Exist   (char*);
BOOL    Exist_A (char*);
BOOL    Exist_B (char*);

// *************************************************
//               User Prototypes
// *************************************************

BOOL    CALLBACK WizMain (void);
BOOL    CALLBACK OnStep1 (HWND, enum_WizAction);
BOOL    CALLBACK OnStep2 (HWND, enum_WizAction);
void    CALLBACK OnFileLine (LPSTR, int);
int     MakeFiles (void);
char    * GetIni (char *, char *, char *);

// *************************************************
//              User GLOBAL SET Statements
// *************************************************

static fileset filesets[]=
{
  "contemplate.bas",IDR_MAIN_CON,TRUE,Project_Win32_Console,
  "guitemplate.bas",IDR_MAIN_GUI,TRUE,Project_Win32_GUI,
  "dlltemplate.bas",IDR_MAIN_DLL,TRUE,Project_Win32_DLL,
  "main.c",IDR_MAIN_C,TRUE,-1,
  "main.rc",IDR_MAIN_RC,TRUE,Project_Win32_GUI,
  "main.h",IDR_MAIN_H,TRUE,Project_Win32_GUI,
  "main.ico",IDR_MAIN_ICO,FALSE,Project_Win32_GUI,
  "",0,0,-1
};


// *************************************************
//                  Main Program
// *************************************************


// *************************************************
//                 Runtime Functions
// *************************************************

char *BCX_TmpStr (size_t Bites)
{
  static int   StrCnt;
  static char *StrFunc[ 512];
  StrCnt=(++StrCnt & 511);
  StrFunc[StrCnt]=(char*)realloc(StrFunc[StrCnt],Bites + 128);
  return (char*)memset(StrFunc[StrCnt],0,Bites+128);
}


int str_cmp (char *a, char *b)
{
  register int counter=0;
  while(1)
   {
    if((a[counter]^b[counter]))
     {
      if((UINT) a[counter]>= (UINT) b[counter])
      return  1;
      return -1;
     }
    if(!a[counter]) return 0;
    counter++;
   }
#if !defined( __cplusplus )
 return 0;
#endif
}


char *left (char *S, int length)
{
  register int tmplen = strlen(S);
  char *strtmp = BCX_TmpStr(tmplen);
  strcpy (strtmp,S);
  if(length>tmplen)
    strtmp[tmplen] = 0;
  else
    strtmp[length] = 0;
  return strtmp;
}


char *mid (char *S, int start, int length)
{
  register int tmplen = strlen(S);
  char *strtmp;
  if(start>tmplen||start<1) return BCX_TmpStr(1);
  if (length < 0) length = tmplen - start + 1;
  strtmp = BCX_TmpStr(length);
  strncpy(strtmp,&S[start-1],length);
  strtmp[length] = 0;
  return strtmp;
}


char *extract (char *mane, char *match)
{
  register char *a;
  register char *strtmp = BCX_TmpStr(strlen(mane));
  strcpy(strtmp,mane);
  a=strstr(mane,match);
  if(a) strtmp[a-mane]=0;
  return strtmp;
}


char *remain (char *mane, char *mat)
{
  register char *p = strstr(mane,mat);
  if(p)
  {
    p+=(strlen(mat));
    return p;
  }
  return mane;
}


char *replace (char *src, char *pat, char *rep)
{
  register size_t patsz, repsz, tmpsz, delta;
  register char *strtmp, *p, *q, *r;
  if (!src) *src = 0;
  if (!pat || !*pat)
   {
     strtmp = BCX_TmpStr(strlen(src));
     if (!strtmp) return NULL;
     return strcpy(strtmp, src);
   }
  if (rep == NULL) *rep = 0;
  repsz = strlen(rep);
  patsz = strlen(pat);
  for (tmpsz=0, p=src; (q=strstr(p,pat))!=0; p=q+patsz)
   tmpsz += (size_t) (q - p) + repsz;
   tmpsz += strlen(p);
   strtmp = BCX_TmpStr(tmpsz);
   if (!strtmp) return NULL;
    for (r=strtmp,p=src; (q=strstr(p,pat))!=0;p=q+patsz)
     {
       delta = (size_t) (q-p);
       strncpy(r,p,delta); r += delta;
       strcpy(r,rep);      r += repsz;
     }
  strcpy(r,p);
  return strtmp;
}


char *lcase (char *S)
{
  register char *strtmp = BCX_TmpStr(strlen(S));
  return strlwr(strcpy(strtmp,S));
}





char *chr (int a,int b,int c,int d,int e,int f,int g,int h,int i,int j)
{
  register char *strtmp = BCX_TmpStr(11);
  strtmp[0]  = a;
  strtmp[1]  = b;
  strtmp[2]  = c;
  strtmp[3]  = d;
  strtmp[4]  = e;
  strtmp[5]  = f;
  strtmp[6]  = g;
  strtmp[7]  = h;
  strtmp[8]  = i;
  strtmp[9]  = j;
  strtmp[10] = 0;
  return strtmp;
}


char * join(int n, ...)
{
  register int i = n, tmplen = 0;
  register char *s_;
  register char *strtmp;
  va_list marker;
  va_start(marker, n); // Initialize variable arguments
  while(i-- > 0)
  {
    s_ = va_arg(marker, char *);
    tmplen += strlen(s_);
  }
  strtmp = BCX_TmpStr(tmplen);
  va_end(marker); // Reset variable arguments
  i = n;
  va_start(marker, n); // Initialize variable arguments
  while(i-- > 0)
  {
    s_ = va_arg(marker, char *);
    strcat(strtmp, s_);
  }
  va_end(marker); // Reset variable arguments
  return strtmp;
}


int InstrRev (char *s, char *p, int os)
{
 register int sl, pl, ox;
 if (!s || !p)
   return 0;
 sl = (int) strlen(s);
 pl = (int) strlen(p);
 if (pl == 0 || (ox = sl - pl) < 0)
   return 0;
 if (os <= 0 || os > ox)
   os = ox + 1;
 for (; os; os--)
   if (strncmp(s + os - 1, p, (size_t) pl) == 0)
     return os;
 return 0;
}


int instr(char* mane,char* match,int offset,int sensflag)
{
  register char *s;
  if (!mane || !match || ! *match || offset>(int)strlen(mane)) return 0;
  if (sensflag)
    s = _stristr_(offset>0 ? mane+offset-1 : mane,match);
  else
    s = strstr (offset>0 ? mane+offset-1 : mane,match);
  return s ? (int)(s-mane)+1 : 0;
}


char *_stristr_(char *String, char *Pattern)
{
  register char *pptr, *sptr, *start;
  register UINT  slen, plen;
  for (start = (char *)String,
    pptr  = (char *)Pattern,
    slen  = strlen(String),
    plen  = strlen(Pattern);
    slen >= plen;
    start++, slen--)
    {
     while (toupper(*start) != toupper(*Pattern))
       {
        start++;
        slen--;
        if (slen < plen)
        return(0);
       }
      sptr = start;
      pptr = (char *)Pattern;
      while (toupper(*sptr) == toupper(*pptr))
        {
         sptr++;
         pptr++;
         if (!*pptr) return (start);
        }
    }
 return(0);
}


BOOL Exist (char *szFilePath)
{
  if(instr(szFilePath,"*")||instr(szFilePath,"?"))
  return Exist_A (szFilePath);
  return Exist_B (szFilePath);
}

BOOL Exist_A (char *szFilePath)
{
  WIN32_FIND_DATA W32FindData;
  HANDLE rc;
  rc = FindFirstFile(szFilePath, &W32FindData);
  if(rc == INVALID_HANDLE_VALUE) return FALSE;
  FindClose(rc);
  return TRUE;
}

BOOL Exist_B (char *szFilePath)
{
  DWORD ret;
  ret = GetFileAttributes(szFilePath);
  if (ret != 0xffffffff) return TRUE;
  return FALSE;
}


char *PellesPath (void)
{
  char *BCX_RetStr={0};
  static char Pelles_Reg[2048];
  static char Pelles_RegPath[2048];
  strcpy(Pelles_Reg,"Software\\Pelle Orinius\\PellesC\\Directories\\");
  strcpy(Pelles_RegPath,(char*)RegString(HKEY_LOCAL_MACHINE,Pelles_Reg,"PathDirs"));
  if(Pelles_RegPath[0]==0)
    {
      strcpy(Pelles_RegPath,(char*)RegString(HKEY_CURRENT_USER,Pelles_Reg,"PathDirs"));
    }
  if(strcmp(Pelles_RegPath,"")!=0)
    {
      BCX_RetStr=BCX_TmpStr(256);
      return strcpy(BCX_RetStr,(char*)left(Pelles_RegPath,InstrRev(Pelles_RegPath,"\\")));
    }
 else
    {
      BCX_RetStr=BCX_TmpStr(strlen(Pelles_RegPath));
      return strcpy(BCX_RetStr,Pelles_RegPath);
    }
}


char *RegString (HKEY hKey, char *RegPath, char *SubKey)
{
  char *Result=BCX_TmpStr(2048);
  int BufferLen=2048;
  if(!RegOpenKeyEx(hKey,RegPath,0,KEY_QUERY_VALUE,&hKey))
    {
   RegQueryValueEx(hKey,SubKey,0,0,(LPBYTE)Result,(LPDWORD)&BufferLen);
    }
  RegCloseKey(hKey);
  return Result;
}



// ************************************
//       User Subs and Functions
// ************************************


BOOL CALLBACK WizMain (void)
{
  char szBuffer[2048];
  char szTail[2048];
  if(!WizGetProjectName(szBuffer,NELEMS(szBuffer)))
    {
      MessageBox (GetActiveWindow(),"GetProjectName",DLLNAME,MB_TYPE);
      return FALSE;
    }
  strcpy(g_szProjname,szBuffer);
  cchProjname=strlen(g_szProjname);
  LoadString(WizGetInstanceHandle(),IDS_APPLICATION,szTail,NELEMS(szTail));
  strcpy(g_szDispname, join(2,szBuffer,szTail));
  static char SyntaxFile[2048];
  memset(&SyntaxFile,0,sizeof(SyntaxFile));
  static char copenfile[2048];
  memset(&copenfile,0,sizeof(copenfile));
  strcpy(SyntaxFile, join(2,PellesPath(),"bin\\addins\\bcxfile.ini"));
  strcpy(copenfile,GetIni("C_FILE","Path",SyntaxFile));
  if(Exist(copenfile))
    {
      strcpy(g_szProjname,extract(mid(copenfile,InstrRev(copenfile,chr(92))+1),"."));
      strcpy(g_szDispname,g_szProjname);
      bcxfileopen=TRUE;
    }
  if(!WizAddStep(MAKEINTRESOURCE(DLG_START),OnStep1))
    {
      MessageBox (GetActiveWindow(),"Step 1 initialization failed",DLLNAME,MB_TYPE);
      return FALSE;
    }
  if(!WizAddStep(MAKEINTRESOURCE(DLG_FINISH),OnStep2))
    {
      MessageBox (GetActiveWindow(),"Step 2  initialization failed",DLLNAME,MB_TYPE);
      return FALSE;
    }
  if(!WizShowSteps())
    {
      return FALSE;
    }
  if(!WizSetProjectType(g_fType))
    {
      MessageBox (GetActiveWindow(),"SetProjectType failed",DLLNAME,MB_TYPE);
      return FALSE;
    }
  if(g_fType==Project_Win32_DLL)
    {
      if(!WizSetProjectSymbol("CCFLAGS","-W1 -Ot -Gz -Ze -Zx -Gn -Go -Tx86-coff"))
        {
          return FALSE;
        }
    }
  else
    {
      if(!WizSetProjectSymbol("CCFLAGS","-W1 -Ot -Gd -Ze -Zx -Go -Tx86-coff "))
        {
          return FALSE;
        }
    }
  if(bcxfileopen)
    {
      if(Exist(copenfile))
        {
          WizAddProjectFile(copenfile);
        }
      bcxfileopen=FALSE;
    }
  else
    {
      if(!MakeFiles())
        {
          return FALSE;
        }
    }
  return TRUE;
}


BOOL CALLBACK OnStep1 (HWND hwnd, enum_WizAction action)
{
  while(1)
  {
    if((action)==Action_SetActive)
      {
        SetDlgItemText(hwnd,DID_DISPNAME,g_szDispname);
        CheckRadioButton(hwnd,DID_CON,DID_DLL,DID_WIN);
        return TRUE;
      }
    if((action)==Action_KillActive)
      {
        GetDlgItemText(hwnd,DID_DISPNAME,g_szDispname,NELEMS(g_szDispname));
        if(IsDlgButtonChecked(hwnd,DID_CON))
          {
            g_fType=Project_Win32_Console;
          }
        else if(IsDlgButtonChecked(hwnd,DID_WIN))
          {
            g_fType=Project_Win32_GUI;
          }
        else
          {
            g_fType=Project_Win32_DLL;
          }
        return g_szDispname[0]!=0;
      }
    break;
  }
  return FALSE;
}


BOOL CALLBACK OnStep2 (HWND hwnd, enum_WizAction action)
{
  char Temp[2048];
  while(1)
  {
    if((action)==Action_SetActive)
      {
        int  i=0;
        int  c=0;
        c=ListBox_GetCount(GetDlgItem(hwnd,DID_RESULTFILES));
        for(i=0; i<=c; i+=1)
          {
            ListBox_DeleteString(GetDlgItem(hwnd,DID_RESULTFILES),0);
          }
        if(bcxfileopen)
          {
            SetDlgItemText(hwnd,DID_Title,"The following files will be loaded...");
            ListBox_AddString(GetDlgItem(hwnd,DID_RESULTFILES),join(2,g_szProjname,".bas"));
            ListBox_AddString(GetDlgItem(hwnd,DID_RESULTFILES),join(2,g_szProjname,".c"));
          }
        else
          {
            SetDlgItemText(hwnd,DID_Title,"The wizard will create the following files...");
            i=0;
            while(filesets[i].pszFile[0]!=0)
              {
                if(g_fType==filesets[i].eProject||filesets[i].eProject==-1)
                  {
                    strcpy(Temp, join(2,".",remain(filesets[i].pszFile,".")));
                    if(str_cmp(Temp,".rc")==0)
                      {
                        strcpy(Temp,"__.rc");
                      }
                    strcpy(Temp, join(2,g_szProjname,Temp));
                    ListBox_AddString(GetDlgItem(hwnd,DID_RESULTFILES),Temp);
                  }
                i++;
              }
          }
        TCHAR  szProjPath[260];
        GetCurrentDirectory(NELEMS(szProjPath),szProjPath);
        SetDlgItemText(hwnd,DID_PROJFOLDER,szProjPath);
        return TRUE;
      }
    if((action)==Action_UpdateUI)
      {
        return TRUE;
      }
    if((action)==Action_KillActive)
      {
        return TRUE;
      }
    break;
  }
  return FALSE;
}


void CALLBACK OnFileLine (LPSTR pszLine, int cchMaxLine)
{
  strcpy(pszLine,replace(pszLine,"<PROJNAME>",g_szProjname));
  strcpy(pszLine,replace(pszLine,"<DISPNAME>",g_szDispname));
}


int MakeFiles (void)
{
  int  i=0;
  static char NewFileName[2048];
  memset(&NewFileName,0,sizeof(NewFileName));
  while(filesets[i].pszFile[0]!=0)
    {
      if(g_fType==filesets[i].eProject||filesets[i].eProject==-1)
        {
          if(filesets[i].bText==TRUE)
            {
              if(!WizWriteTextFileFromResourceA(filesets[i].pszFile,MAKEINTRESOURCE(filesets[i].IDR_FILE),OnFileLine))
                {
                  MessageBox (GetActiveWindow(),filesets[i].pszFile,"WriteTextFileFromResource error ",MB_TYPE);
                  return FALSE;
                }
            }
          if(filesets[i].bText==FALSE)
            {
              if(!WizWriteFileFromResourceA(filesets[i].pszFile,MAKEINTRESOURCE(filesets[i].IDR_FILE)))
                {
                  MessageBox (GetActiveWindow(),filesets[i].pszFile,"WriteFileFromResource error ",MB_TYPE);
                  return FALSE;
                }
            }
        }
      i++;
    }
  i=0;
  while(filesets[i].pszFile[0]!=0)
    {
      char pszC[2048];
      strcpy(pszC,filesets[i].pszFile);
      if(g_fType==filesets[i].eProject||filesets[i].eProject==-1)
        {
          strcpy(NewFileName, join(2,".",remain(filesets[i].pszFile,".")));
          if(str_cmp(NewFileName,".rc")==0)
            {
              strcpy(NewFileName,"__.rc");
            }
          strcpy(NewFileName, join(2,g_szProjname,NewFileName));
          MoveFile (filesets[i].pszFile,NewFileName);
          strcpy(pszC,lcase(remain(pszC,".")));
          if(str_cmp(pszC,"c")==0 || str_cmp(pszC,"rc")==0)
            {
              if(!WizAddProjectFile(NewFileName))
                {
                  MessageBox (GetActiveWindow(),NewFileName,"AddProjectFile error ",MB_TYPE);
                  return FALSE;
                }
            }
        }
      i++;
    }
  return TRUE;
}


char * GetIni (char *Section, char *Var, char *File)
{
  char *BCX_RetStr={0};
  char *Buffer;
  Buffer=(char*)calloc(256+MAX_PATH,1);
  int      Length;
  Length=GetPrivateProfileString(Section,Var,"",Buffer,MAX_PATH,File);
  strcpy(Buffer,left(Buffer,Length));
  BCX_RetStr=BCX_TmpStr(strlen(Buffer));
  strcpy(BCX_RetStr,Buffer);
  if(Buffer)free(Buffer);
  return BCX_RetStr;
}


