'==============================================================================
'
' Fil     : BCXWizard.bas
'
' Purpose : PellesC Wizard to set up a BCX compatible project.
'
' History : Date       Reason
'           6-11-04    Created
'
'==============================================================================

$NODLLMAIN
$DLL STDCALL
$TURBO

#include <tchar.h>
#include <wizard.h>
#include "BCXWizard.h"

$HEADER
#define NELEMS(a)  (sizeof(a) / sizeof(a[0]))
#define enum_WizAction enum WizAction
$HEADER

CONST DLLNAME$ = "BCX Wizard"
CONST MB_TYPE = MB_OK BOR MB_ICONERROR BOR MB_APPLMODAL BOR MB_TOPMOST
GLOBAL g_szProjname$
GLOBAL g_szDispname$
GLOBAL g_fType AS INTEGER
GLOBAL cchProjname AS INTEGER
GLOBAL bcxfileopen AS BOOL

TYPE fileset
   pszFile AS char PTR
   IDR_FILE AS WORD
   bText AS BOOL
   eProject AS INTEGER
END TYPE
SET filesets[] AS fileset
   "contemplate.bas", IDR_MAIN_CON, TRUE, Project_Win32_Console,
   "guitemplate.bas", IDR_MAIN_GUI, TRUE, Project_Win32_GUI,
   "dlltemplate.bas", IDR_MAIN_DLL, TRUE, Project_Win32_DLL,
   "main.c", IDR_MAIN_C, TRUE, -1,
   "main.rc", IDR_MAIN_RC, TRUE, Project_Win32_GUI,
   "main.h", IDR_MAIN_H, TRUE, Project_Win32_GUI,
   "main.ico", IDR_MAIN_ICO, FALSE, Project_Win32_GUI,
   "", 0, 0, -1
END SET

'==============================================================================
'
' Function: WizMain()
'
' Purpose : Entry point
'
' History : Date       Reason
'           6-11-04    Created
'
'==============================================================================

FUNCTION WizMain () AS BOOL CALLBACK
   DIM RAW szBuffer$
   DIM RAW szTail$

   IF  NOT  WizGetProjectName (szBuffer, NELEMS (szBuffer)) THEN
      MSGBOX "GetProjectName", DLLNAME$, MB_TYPE
      FUNCTION = FALSE
   END IF
   g_szProjname$ = szBuffer$
   cchProjname = LEN(g_szProjname$)

   ' Build a default display name.
   LoadString (WizGetInstanceHandle(), IDS_APPLICATION, szTail, NELEMS (szTail))

   g_szDispname$ = szBuffer$ + szTail$

   'Check to see if wizard was called from BCX addin.
   DIM SyntaxFile$, copenfile$
   SyntaxFile$ = PELLESPATH$ + "bin\addins\bcxfile.ini"
   copenfile$ = GetIni ("C_FILE","Path",SyntaxFile$)
   IF EXIST(copenfile$) THEN
      'The wizard was called from the addin. Change the project name to C file name
      g_szProjname$ = EXTRACT$(MID$(copenfile$,INSTRREV(copenfile$,"\")+1),".")
      g_szDispname$ = g_szProjname$
      bcxfileopen = TRUE
   END IF

   IF  NOT  WizAddStep (MAKEINTRESOURCE (DLG_START), OnStep1) THEN
      MSGBOX "Step 1 initialization failed", DLLNAME$, MB_TYPE
      FUNCTION = FALSE
   END IF
   IF  NOT  WizAddStep (MAKEINTRESOURCE (DLG_FINISH), OnStep2) THEN
      MSGBOX "Step 2  initialization failed", DLLNAME$, MB_TYPE
      FUNCTION = FALSE
   END IF
   IF  NOT  WizShowSteps () THEN
      FUNCTION = FALSE
   END IF

   IF  NOT  WizSetProjectType (g_fType) THEN
      MSGBOX "SetProjectType failed", DLLNAME$, MB_TYPE
      FUNCTION = FALSE
   END IF

   'Set compiler flags the way BCX expects them
   IF g_fType = Project_Win32_DLL THEN
      'Standard call dll
      IF NOT WizSetProjectSymbol("CCFLAGS", "-W1 -Ot -Gz -Ze -Zx -Gn -Go -Tx86-coff") THEN FUNCTION = FALSE
   ELSE
      'Windows or Console program with PellesC extensions
      IF NOT WizSetProjectSymbol("CCFLAGS", "-W1 -Ot -Gd -Ze -Zx -Go -Tx86-coff ") THEN FUNCTION = FALSE
   END IF

   'If the Wizard was called from the BCX addin, then load the C source
   IF bcxfileopen THEN
      IF EXIST(copenfile$) THEN
         WizAddProjectFile (copenfile$)
      END IF
      bcxfileopen = FALSE
   ELSE
      'Else load the template code
      IF  NOT  MakeFiles () THEN
         FUNCTION = FALSE
      END IF
   END IF
   FUNCTION = TRUE
END FUNCTION

'==============================================================================
'
' Function: OnStep1()
'
' Purpose : Code to handle first Dialog Box
'
' History : Date       Reason
'           6-11-04    Created
'
'==============================================================================

FUNCTION OnStep1 (hwnd AS HWND, action AS enum_WizAction) AS BOOL CALLBACK
   SELECT CASE (action)
      ' Set the display name and default project type.
      CASE Action_SetActive
      SetDlgItemText (hwnd, DID_DISPNAME, g_szDispname)
      CheckRadioButton(hwnd, DID_CON, DID_DLL, DID_WIN)
      FUNCTION = TRUE

      ' Remember the display name and Project Type.
      CASE Action_KillActive
      GetDlgItemText (hwnd, DID_DISPNAME, g_szDispname, NELEMS (g_szDispname))
      IF IsDlgButtonChecked(hwnd, DID_CON) THEN
         g_fType = Project_Win32_Console
      ELSEIF IsDlgButtonChecked(hwnd, DID_WIN) THEN
         g_fType = Project_Win32_GUI
      ELSE
         g_fType = Project_Win32_DLL
      END IF
      FUNCTION = g_szDispname[0] <> 0
   END SELECT

   FUNCTION = FALSE
END FUNCTION

'==============================================================================
'
' Function: OnStep2()
'
' Purpose : Code for Second Dialog box
'
' History : Date       Reason
'           6-11-04    Created
'
'==============================================================================

FUNCTION OnStep2 (hwnd AS HWND, action AS enum_WizAction) AS BOOL CALLBACK
   DIM RAW Temp$
   SELECT CASE (action)
      CASE Action_SetActive
      DIM RAW i = 0 AS INTEGER
      DIM RAW c = 0 AS INTEGER

      'Must empty list box in case user uses the back button
      c = ListBox_GetCount(GetDlgItem (hwnd, DID_RESULTFILES))
      FOR i = 0 TO c
         ListBox_DeleteString(GetDlgItem (hwnd, DID_RESULTFILES),0)
      END IF

      'Display files in list box
      IF bcxfileopen THEN
         'Wizard called from adin
         SetDlgItemText (hwnd, DID_Title, "The following files will be loaded...")
         ListBox_AddString (GetDlgItem (hwnd, DID_RESULTFILES), g_szProjname$ + ".bas")
         ListBox_AddString (GetDlgItem (hwnd, DID_RESULTFILES), g_szProjname$ + ".c")
      ELSE
         'Display template files
         SetDlgItemText (hwnd, DID_Title, "The wizard will create the following files...")
         i = 0
         WHILE filesets[i].pszFile[0] <> 0
            IF g_fType = filesets[i].eProject OR filesets[i].eProject = -1 THEN
               Temp$ = "." + REMAIN$(filesets[i].pszFile$,".")
               IF Temp$ = ".rc" THEN Temp$ = "__.rc"
               Temp$ = g_szProjname$ + Temp$
               ListBox_AddString (GetDlgItem (hwnd, DID_RESULTFILES), Temp$)
            END IF
            i++
         WEND
      END IF

      DIM RAW szProjPath[260] AS TCHAR
      GetCurrentDirectory (NELEMS (szProjPath), szProjPath)
      SetDlgItemText (hwnd, DID_PROJFOLDER, szProjPath)

      FUNCTION = TRUE

      CASE Action_UpdateUI

      FUNCTION = TRUE

      CASE Action_KillActive

      FUNCTION = TRUE

   END SELECT
   FUNCTION = FALSE
END FUNCTION

'==============================================================================
'
' Function: OnFileLine()
'
' Purpose : Search and replace text while writing to disk
'
' History : Date       Reason
'           6-11-04    Created
'
'==============================================================================

'  normally 4096 chars
FUNCTION OnFileLine (pszLine AS LPSTR, cchMaxLine AS INTEGER) AS void CALLBACK

   REPLACE "<PROJNAME>" WITH g_szProjname$ IN pszLine$
   REPLACE "<DISPNAME>" WITH g_szDispname$ IN pszLine$

END FUNCTION

'==============================================================================
'
' Function: MakeFiles()
'
' Purpose : Write out the files to disk
'
' History : Date       Reason
'           6-11-04    Created
'
'==============================================================================

FUNCTION MakeFiles () AS INTEGER
   DIM RAW  i = 0 AS int
   DIM NewFileName$


   WHILE filesets[i].pszFile[0] <> 0
      IF g_fType = filesets[i].eProject OR filesets[i].eProject = -1 THEN
         IF filesets[i].bText = TRUE THEN
            IF  NOT  WizWriteTextFileFromResourceA (filesets[i].pszFile, MAKEINTRESOURCE (filesets[i].IDR_FILE), OnFileLine) THEN
               MSGBOX filesets[i].pszFile$, "WriteTextFileFromResource error ", MB_TYPE
               FUNCTION = FALSE
            END IF
         END IF
         IF filesets[i].bText = FALSE THEN
            IF  NOT  WizWriteFileFromResourceA (filesets[i].pszFile, MAKEINTRESOURCE (filesets[i].IDR_FILE)) THEN
               MSGBOX filesets[i].pszFile$, "WriteFileFromResource error ", MB_TYPE
               FUNCTION = FALSE
            END IF
         END IF
      END IF
      i++
   WEND

   i = 0
   WHILE filesets[i].pszFile[0] <> 0
      DIM RAW pszC$
      pszC$ = filesets[i].pszFile

      IF g_fType = filesets[i].eProject OR filesets[i].eProject = -1 THEN
         NewFileName$ = "." + REMAIN$(filesets[i].pszFile$,".")
         IF NewFileName$ = ".rc" THEN NewFileName$ = "__.rc"
         NewFileName$ = g_szProjname$ + NewFileName$
         RENAME filesets[i].pszFile$, NewFileName$

         pszC$ = LCASE$(REMAIN$(pszC$,"."))
         IF pszC$ = "c" OR  pszC$ = "rc" THEN
            IF  NOT  WizAddProjectFile (NewFileName$) THEN
               MSGBOX NewFileName$, "AddProjectFile error ", MB_TYPE
               FUNCTION = FALSE
            END IF
         END IF
      END IF
      i++
   WEND

   FUNCTION = TRUE
END FUNCTION


'==============================================================================
'
' Function: GetIni$()
'
' Purpose : Reade a INI file
'
' History : Date       Reason
'           6-11-04    Created
'
'==============================================================================

Function GetIni$ (Section$, Var$, File$)
   Dim Buffer$ * MAX_PATH
   DIM RAW Length%

   Length  = GetPrivateProfileString(Section$,Var$,"",Buffer$,MAX_PATH,File$)
   Buffer$  = Left$(Buffer$,Length)
   Function = Buffer$
End Function



