'***************************************************************************
'
' File    : bcxfile.bas
'
' Purpose : Parser add-in DLL. Supports BCX syntax.
'
' History : Date       Reason
'           16-10-04   Modified for BCX by GOK
'           20-12-04   Modified to work with long file names in the BCX path
'
'***************************************************************************
$NODLLMAIN
$DLL STDCALL
$LEANANDMEAN
$TURBO

#include <addin.h>
'Use constants from wizard.h for consistency
#include <wizard.h>
#include <assert.h>
#include "BCXFile.h"

' Helper macro for assigning color to column position.
$HEADER
#define DEFINE_COLOR(pos,color) \
assert((pos) >= 0 && (pos) < cchText); \
if (aPoints != NULL){ \
   if (*pcPoints == 0 || aPoints[(*pcPoints)-1].iChar <= (pos)){ \
      aPoints[(*pcPoints)].iChar = (pos);\
      aPoints[(*pcPoints)].iColor = (color);\
      (*pcPoints)++; \
   } \
}
$HEADER

CONST ID_BCX = 1
CONST ID_OPENBCX = 2
CONST DllName$ = "BCX Helper DLL"

' Flags for usCookie.
CONST FLAG_COMMENT   = 0x01
CONST FLAG_STRING    = 0x02
CONST FLAG_MLCOMMENT = 0x04
CONST FLAG_UNUSED2   = 0x08                                'Free for any use.
CONST FLAG_UNUSED3   = 0x10                                'Free for any use.
CONST FLAG_UNUSED4   = 0x20                                'Free for any use.
CONST FLAG_UNUSED5   = 0x40                                'Free for any use.
CONST FLAG_UNUSED6   = 0x80                                'Free for any use.
    
GLOBAL apszKeywords AS LPSTR PTR
GLOBAL apszPrePro   AS PCHAR PTR
GLOBAL apszFunction AS PCHAR PTR
GLOBAL apszOperator AS PCHAR PTR
GLOBAL kwin%, ppin%, fnin%, opin%

GLOBAL g_hmod     AS HANDLE
GLOBAL g_hwndMain AS HANDLE
GLOBAL g_hwndPrj  AS HANDLE
GLOBAL g_fType    AS INTEGER
'***************************************************************************
'
' Function: DllMain
'
' Purpose : DLL entry and exit procedure.
'
' History : Date       Reason
'           16-10-04   Modified for BCX by GOK
'
'***************************************************************************

FUNCTION DllMain (hDLL AS HANDLE, dwReason AS DWORD, lpReserved AS LPVOID) AS BOOL CALLBACK
   SELECT CASE (dwReason)
      CASE DLL_PROCESS_ATTACH
      g_hmod = hDLL
      FUNCTION = TRUE

      CASE DLL_PROCESS_DETACH
      FUNCTION = TRUE
   END SELECT

   FUNCTION = TRUE
END FUNCTION

'***************************************************************************
'
' Function: AddInMain
'
' Purpose : Add-in entry and exit procedure.
'
' History : Date       Reason
'           16-10-04   Modified for BCX by GOK
'
'***************************************************************************
CONST ADDINAPI_BOOL = ADDINAPI BOOL

FUNCTION AddInMain (hwnd AS HWND, eEvent AS ADDIN_EVENT) AS ADDINAPI_BOOL CALLBACK
   SELECT CASE (eEvent)
      CASE AIE_APP_CREATE
      DIM RAW AddFile = {0} AS ADDIN_ADD_FILE_TYPE
      DIM RAW AddCmd = {0} AS ADDIN_ADD_COMMAND

      g_hwndMain = hwnd

      ' Load Syntax file
      IF NOT OpenINIFile() THEN FUNCTION = FALSE

      ' Define a new file type in the IDE
      AddFile.cbSize = sizeof (AddFile)
      AddFile.pszDescription = "BCX Source file"
      AddFile.pszExtension = "bas"                         'support *.BAS files
      AddFile.pfnParser = Parser
			DIM temp$
      GetShortPathName(BCXPATH$,temp$,2048)
			$IPRINT_OFF
      temp$ = temp$ + "BC " + "$*.bas -p -i\0$(CC) -c $*.c\0"
      AddFile.pszShells = temp$
      $IPRINT_ON
      IF  NOT  AddIn_AddFileType (hwnd, &AddFile) THEN
         FUNCTION = FALSE
      END IF

      ' Add a button to toolbar
      AddCmd.cbSize = sizeof(AddCmd)
      AddCmd.pszText = "BCX build"                         ' Tooltip text.
      AddCmd.hIcon = LoadImage(g_hmod, MAKEINTRESOURCE(IDR_BCXICON), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR|LR_SHARED)
      AddCmd.id = ID_BCX
      AddCmd.idMenu = AIM_MENU_NOTHING
      IF NOT AddIn_AddCommand(hwnd, &AddCmd) THEN
         FUNCTION = FALSE
      END IF
      'Add helper right click menu to Project Window to
      'quick load the BCX file
      AddCmd.pszText = "Find BCX file"
      AddCmd.id = ID_OPENBCX
      AddCmd.hIcon = (HICON)NUL$
      AddCmd.idMenu = AIM_MENU_PROJECT_CONTEXT
      IF NOT AddIn_AddCommand(hwnd, &AddCmd) THEN
         FUNCTION = FALSE
      END IF
      FUNCTION = TRUE

      CASE AIE_PRJ_CREATE
      g_hwndPrj = hwnd
      FUNCTION = TRUE

      CASE AIE_PRJ_DESTROY
      g_hwndPrj = NULL
      FUNCTION = TRUE

      CASE AIE_APP_DESTROY
      FreeDynamicArray()
      AddIn_RemoveCommand(hwnd, ID_OPENBCX)
      AddIn_RemoveCommand(hwnd, ID_BCX)
      FUNCTION = TRUE

   END SELECT
   FUNCTION = TRUE
END FUNCTION

'***************************************************************************
'
' Function: Parser
'
' Purpose : Parse source code - for syntax color highlighting.
'
' History : Date      Reason
'           16-10-04  Modified for BCX by GOK
'
'***************************************************************************

FUNCTION Parser (usCookie AS USHORT, pszText AS PCTSTR, cchText AS INTEGER, aPoints[] AS ADDIN_PARSE_POINT, pcPoints AS PINT) AS USHORT
   DIM RAW cFoldLevel AS BYTE
   DIM RAW iRedefine = 0 AS INTEGER
   DIM RAW iIdentBegin = - 1 AS INTEGER
   DIM RAW fSeenEnd = FALSE AS BOOL
   DIM RAW fSeenExit = FALSE AS BOOL
   DIM RAW fSeenDeclare = FALSE AS BOOL
   DIM RAW i AS INTEGER

   GLOBAL InFunction AS BOOL

   ' usCookie - (IN) saved state from previous line (zero for first line) - flags (1 byte), folding level (1 byte).
   ' pszText  - (IN) pointer to text to parse.
   ' cchText  - (IN) length of text to parse (can be zero, for empty lines!).
   ' aPoints  - (OUT) array of ADDIN_PARSE_POINT that specifies color changes. Large enough for a color change
   '                  on each character in the largest supported line length (4096 characters).
   ' pcPoints - (OUT) number of entries stored in aPoints[].

   ' quick exit for empty lines.
   IF cchText = 0 THEN
      FUNCTION = usCookie
   END IF
   ' break up cookie in low and high byte.
   cFoldLevel = ADDIN_GET_COOKIE_LEVEL (usCookie)
   usCookie = ADDIN_GET_COOKIE_FLAGS (usCookie)

   i = 0
   WHILE TRUE
      IF iRedefine >= 0 THEN
         IF usCookie BAND FLAG_COMMENT THEN
            DEFINE_COLOR (iRedefine, ADDIN_COLOR_COMMENT)
         ELSEIF usCookie BAND (FLAG_STRING) THEN
            DEFINE_COLOR (iRedefine, ADDIN_COLOR_STRING)
         ELSE
            DEFINE_COLOR (iRedefine, ADDIN_COLOR_TEXT)
         END IF
         iRedefine = - 1
      END IF
      ' check for end of line.
      IF i = cchText THEN
         EXIT LOOP
      END IF
      ' inside a single line comment: '
      IF usCookie BAND FLAG_COMMENT THEN
         DEFINE_COLOR (i, ADDIN_COLOR_COMMENT)
         usCookie |= FLAG_COMMENT
         EXIT LOOP
      END IF
      ' inside a multi-line comment: $COMMENT
      IF usCookie BAND FLAG_MLCOMMENT THEN
         DEFINE_COLOR (i, ADDIN_COLOR_COMMENT)
         IF _strnicmp("$comment", pszText+ i, 8) = 0 THEN
            usCookie = usCookie BAND ~FLAG_MLCOMMENT
         END IF
         i++
         ITERATE
      END IF
      ' inside a string constant: "...."
      IF usCookie BAND FLAG_STRING THEN
         ' check for end of string constant...
         IF pszText[i] = 34 THEN
            usCookie &= ~FLAG_STRING
            iRedefine = i + 1
         END IF
         i++
         ITERATE
      END IF
      ' check for a single line comment: '
      IF pszText[i] = 39 THEN
         DEFINE_COLOR (i, ADDIN_COLOR_COMMENT)
         usCookie |= FLAG_COMMENT
         EXIT LOOP
      END IF
      ' check for multi-line comment
      IF _strnicmp("$comment", pszText+ i, 8) = 0 THEN
         DEFINE_COLOR (i, ADDIN_COLOR_COMMENT)
         usCookie |= FLAG_MLCOMMENT
         EXIT LOOP
      END IF
      ' check for a string constant: "...."
      IF pszText[i] = 34 THEN
         DEFINE_COLOR (i, ADDIN_COLOR_STRING)
         usCookie |= FLAG_STRING
         i++
         ITERATE
      END IF
      ' handle identifiers and keywords.
      IF isalnum (pszText[i])  OR pszText[i] = 35 OR pszText[i] = 36 OR  pszText[i] = 95 THEN      '95 = ASC("_")
         ' remember where the identifier/keyword starts.
         IF iIdentBegin = - 1 THEN
            iIdentBegin = i
         END IF
      ELSE
         IF iIdentBegin >= 0 THEN
            IF IsKeyword(apszKeywords, kwin%, pszText + iIdentBegin, i - iIdentBegin) THEN
               DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_KEYWORD)

               ' special (hackish) handling of folding points for FUNCTION and SUB.
               IF  NOT  fSeenExit  AND   NOT  fSeenDeclare  AND  _strnicmp("function", pszText + iIdentBegin, i - iIdentBegin) = 0 THEN
                  ' END FUNCTION - decrease level.
                  IF fSeenEnd  AND  cFoldLevel > 0 THEN
                     cFoldLevel--
                     InFunction = FALSE
                  ELSEIF  NOT  fSeenEnd  AND  cFoldLevel < 255 THEN  ' FUNCTION - increase level.
                     IF NOT InFunction THEN
                        cFoldLevel++
                        InFunction = TRUE
                     END IF
                  END IF
               ELSEIF  NOT  fSeenExit  AND  _strnicmp("sub", pszText + iIdentBegin, i - iIdentBegin) = 0 THEN
                  ' END SUB - decrease level.
                  IF fSeenEnd  AND  cFoldLevel > 0 THEN
                     cFoldLevel--
                     ' SUB - increase level.
                  ELSEIF  NOT  fSeenEnd  AND  cFoldLevel < 255 THEN
                     cFoldLevel++
                  END IF
               ELSE
                  ' remember if we seen END or EXIT, to distinguish between FUNCTION, END FUNCTION, EXIT FUNCTION.
                  IF _strnicmp("end",pszText+iIdentBegin,i-iIdentBegin)=0 THEN fSeenEnd = TRUE ELSE  fSeenEnd = FALSE
                  IF _strnicmp("exit",pszText+iIdentBegin,i-iIdentBegin)=0 THEN fSeenExit = TRUE ELSE fSeenExit = FALSE
                  IF _strnicmp("declare",pszText+iIdentBegin,i-iIdentBegin)=0 THEN fSeenDeclare = TRUE ELSE fSeenDeclare = FALSE
               END IF
            ELSEIF IsNumber(pszText + iIdentBegin, i - iIdentBegin) THEN
               DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_NUMBER)
            ELSEIF IsKeyword(apszPrePro, ppin%, pszText + iIdentBegin, i - iIdentBegin) THEN
               DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_PREPROCESSOR)
            ELSEIF IsKeyword(apszFunction, fnin%, pszText + iIdentBegin, i - iIdentBegin) THEN
               DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_FUNCTION)
            ELSEIF IsKeyword(apszOperator, opin%, pszText + iIdentBegin, i - iIdentBegin) THEN
               DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_OPERATOR)
            END IF
            iRedefine = i
            iIdentBegin = - 1
         END IF
      END IF
      i++
   WEND

   ' handle dangling identifiers and keywords. (needed for the last keyword in source)
   IF iIdentBegin >= 0 THEN
      IF IsKeyword(apszKeywords, kwin%, pszText + iIdentBegin, i - iIdentBegin) THEN
         DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_KEYWORD)

         ' special (hackish) handling of folding points for FUNCTION and SUB.
         IF  NOT  fSeenExit  AND   NOT  fSeenDeclare  AND  _strnicmp("function", pszText + iIdentBegin, i - iIdentBegin) = 0 THEN
            ' END FUNCTION - decrease level.
            IF fSeenEnd  AND  cFoldLevel > 0 THEN
               cFoldLevel--
               ' FUNCTION - increase level.
            ELSEIF  NOT  fSeenEnd  AND  cFoldLevel < 255 THEN
               cFoldLevel++
            END IF
         ELSEIF  NOT  fSeenExit  AND  _strnicmp("sub", pszText + iIdentBegin, i - iIdentBegin) = 0 THEN
            ' END SUB - decrease level.
            IF fSeenEnd  AND  cFoldLevel > 0 THEN
               cFoldLevel--
               ' SUB - increase level.
            ELSEIF  NOT  fSeenEnd  AND  cFoldLevel < 255 THEN
               cFoldLevel++
            END IF
         END IF
      ELSEIF IsNumber(pszText + iIdentBegin, i - iIdentBegin) THEN
         DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_NUMBER)
      ELSEIF IsKeyword(apszPrePro, ppin%, pszText + iIdentBegin, i - iIdentBegin) THEN
         DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_PREPROCESSOR)
      ELSEIF IsKeyword(apszFunction, fnin%, pszText + iIdentBegin, i - iIdentBegin) THEN
         DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_FUNCTION)
      ELSEIF IsKeyword(apszOperator, opin%, pszText + iIdentBegin, i - iIdentBegin) THEN
         DEFINE_COLOR (iIdentBegin, ADDIN_COLOR_OPERATOR)
      END IF
   END IF
   ' return cookie: flags and folding level that the next line will see.
   FUNCTION = ADDIN_MAKE_COOKIE (usCookie BAND ~FLAG_COMMENT, cFoldLevel)
END FUNCTION

'***************************************************************************
'
' Function: IsKeyword
'
' Purpose : Return TRUE if the passed string is a keyword.
'
' History : Date       Reason
'           16-10-04   Modified for BCX by GOK
'           19-11-04   Changed variable "this" to "tthis" (reserved word in BCX)
'
'***************************************************************************

FUNCTION IsKeyword(anyKeywords[] AS PTSTR, cKeywords AS INTEGER, pszText AS PCTSTR, cchText AS INTEGER) AS BOOL
   DIM RAW lo = 0 AS INTEGER
   DIM RAW hi = cKeywords - 1 AS INTEGER

   ' binary search
   WHILE hi >= lo
      DIM RAW tthis AS INTEGER
      tthis = (lo + hi) / 2
      DIM RAW cond AS INTEGER                              'case insensitive
      cond = _strnicmp(anyKeywords[tthis], pszText, cchText)

      IF cond > 0 THEN
         hi = tthis - 1
      ELSEIF cond < 0 THEN
         lo = tthis + 1
      ELSEIF anyKeywords[tthis][cchText] = 0 THEN
         FUNCTION = TRUE
      ELSEIF IsKeyword(anyKeywords + lo, tthis - lo, pszText, cchText) THEN
         FUNCTION = TRUE
      ELSEIF IsKeyword(anyKeywords + tthis + 1, hi - tthis, pszText, cchText) THEN
         FUNCTION = TRUE
      ELSE
         EXIT LOOP
      END IF
   WEND

   FUNCTION = FALSE
END FUNCTION

'***************************************************************************
'
' Function: IsNumber
'
' Purpose : Return TRUE if the passed string is a number.
'
' History : Date       Reason
'           16-10-04   Modified for BCX by GOK
'
'***************************************************************************

FUNCTION IsNumber(pszText AS PCTSTR, cchText AS INTEGER) AS BOOL
   ' Very *simple* test for numbers - floats, hex constants, are not handled.
   DIM RAW  i = 0 AS int
   WHILE i<cchText
      IF NOT isdigit(pszText[i]) THEN
         FUNCTION = FALSE
      END IF
      i++
   WEND

   FUNCTION = TRUE
END FUNCTION

'***************************************************************************
'
' Function: AddInCommandEx
'
' Purpose : Process clicks on the Main window user button "BCX"
'
' History : Date       Reason
'           16-10-04   Created
'
'***************************************************************************

CONST ADDINAPI_void = ADDINAPI void
FUNCTION AddInCommandEx(idCmd AS INTEGER, pcvData AS LPCVOID) AS ADDINAPI_void CALLBACK

   IF idCmd = ID_BCX THEN
      DIM RAW hwndDoc = NULL AS HWND
      DIM RAW DocInfo = {0} AS  ADDIN_DOCUMENT_INFO
      DIM mbmsg$
      DIM bcxbuf$, cbuf$, ccbuf$, temp$
      DIM RAW SyntaxFile$
      
      DocInfo.cbSize = sizeof(DocInfo)

      'Process the active document name
      hwndDoc = AddIn_GetActiveDocument(g_hwndMain)
      IF hwndDoc = NULL THEN
         MSGBOX "The BCX Source file must be Open in the POIDE", DllName$, 0
         EXIT SUB
      END IF

      AddIn_GetDocumentInfo(hwndDoc, &DocInfo)
      IF NOT *DocInfo.szFilename THEN
         mbmsg$ = "Cannot find BCX source file. Make sure it is open in POIDE," & _
         CRLF$ & "and has a valid filename"
         MSGBOX mbmsg$, DllName$, 0
         EXIT SUB
      END IF

      bcxbuf$ = DocInfo.szFilename
      'Some users might not like forcing the extension like this.
      'I always make the mistake of translating when the C file is
      'open so I like to switch names. Comment it out if you wish.
      '-----------------------------------------------
      bcxbuf$ = LCASE$(EXTRACT$(bcxbuf$,".")) + ".bas"
      '-----------------------------------------------
      cbuf$ = LCASE$(EXTRACT$(bcxbuf$,".")) + ".c"
      IF NOT EXIST(bcxbuf$) THEN
         mbmsg$ = "Cannot find BCX source file." & CRLF$ & bcxbuf$
         MSGBOX mbmsg$, DllName$, 0
         EXIT SUB
      END IF
      'Make copy of file name.
      ccbuf$ = cbuf$
      CALL CloseOpenWindows(ccbuf$)
      AddIn_SendIDECommand(g_hwndMain, AIC_FILE_SAVEALL)
      'Convert to short file name
      GetShortPathName(BCXPATH$,temp$,2048)
      bcxbuf$ = temp$ + "BC " + ENC$(bcxbuf$) + " -p -i"
      SHELL bcxbuf$

      IF EXIST(cbuf$) THEN
         IF g_hwndPrj = NULL THEN
            'No active project,  create one.
            IF g_fType <> -1 THEN
               SyntaxFile$ = PELLESPATH$ + "bin\addins\bcxfile.ini"
               IF EXIST(SyntaxFile$) THEN
                  WritePrivateProfileString("C_FILE","Path",cbuf$,SyntaxFile$)
                  AddIn_SendIDECommand(g_hwndMain, AIC_FILE_NEWPROJECT)
                  WritePrivateProfileString("C_FILE","Path","",SyntaxFile$)
               END IF
            END IF
         END IF
         AddIn_SendIDECommand(g_hwndMain, AIC_PROJ_BUILDALL)

         'ccbuf$ is set to null to flag that the file was closed
         IF ccbuf$ = "" THEN
            'Reload the C file
            AddIn_OpenDocument(g_hwndMain, AID_SOURCE, cbuf$)
            'Set focus back to active document
            AddIn_SendIDECommand(g_hwndMain, AIC_MISC_NEXTWINDOW)
            'SetFocus(hwndDoc)
         END IF
      ELSE
         MSGBOX "Build failed", DllName$, 0
      END IF
   END IF

   IF idCmd = ID_OPENBCX THEN
      IF NOT IsBadStringPtr(pcvData, 260) THEN
         DIM RAW bcxbuf$
         bcxbuf$ = pcvData$
         bcxbuf$ = EXTRACT$(bcxbuf$,".") + ".bas"
         IF EXIST(bcxbuf$) THEN
            AddIn_OpenDocument(g_hwndMain, AID_UNKNOWN, bcxbuf$)
         END IF
      END IF
   END IF
END FUNCTION

'***************************************************************************
'
' Function: CloseOpenWindows
'
' Purpose : Sets up the callback CloseWindowCallback to check all
'           open windows for the C source file
'
' History : Date       Reason
'           17-10-04   Created
'
'***************************************************************************

SUB CloseOpenWindows(filein$)
   DIM RAW mEnum = {0} AS ADDIN_ENUM_DOCUMENTS

   mEnum.cbSize = sizeof(mEnum)
   mEnum.pfnCallback = CloseWindowCallback
   mEnum.pvData = filein

   AddIn_EnumDocuments(g_hwndMain, &mEnum)
END SUB

'***************************************************************************
'
' Function: CloseWindowCallback
'
' Purpose : Closes the C source file before running the BCX translator
'
' History : Date       Reason
'           17-10-04   Created
'
'***************************************************************************

FUNCTION CloseWindowCallback(hwndDoc AS HWND, pvData AS LPVOID) AS BOOL CALLBACK
   DIM RAW DocInfo = {0} AS  ADDIN_DOCUMENT_INFO
   DocInfo.cbSize = sizeof(DocInfo)
   DIM RAW lpvData AS LPSTR
   lpvData = (LPSTR)pvData

   IF hwndDoc <> NULL THEN
      IF AddIn_GetDocumentInfo(hwndDoc, &DocInfo) THEN
         IF *DocInfo.szFilename THEN
            IF lpvData$ = LCASE$(DocInfo.szFilename$) THEN
               'Close the C file (reload after translation complete)
               AddIn_CloseDocument(hwndDoc)
               'Use this as a flag to show file was closed
               *lpvData = 0
            END IF
         END IF
      END IF
   END IF

   FUNCTION = TRUE
END FUNCTION

'***************************************************************************
'
' Function: DynStrCompareA
'
' Purpose : Comparison function for qsort
'
' History : Date       Reason
'           23-10-04   Created
'
'***************************************************************************
CONST int_cdecl = int __cdecl
CONST cvoid = const void

FUNCTION DynStrCompareA(arg1 AS cvoid PTR, arg2 AS cvoid PTR) AS int_cdecl
   DIM RAW v1 AS PCHAR
   DIM RAW v2 AS PCHAR
   DIM RAW i

   v1 = *(char **)arg1
   v2 = *(char **)arg2
   i = lstrcmpi(v1, v2)
   FUNCTION = i
END FUNCTION

'***************************************************************************
'
' Function: OpenINIFile
'
' Purpose : Load INI Syntax file from Addins folder
'
' History : Date       Reason
'           23-10-04   Created
'
'***************************************************************************

FUNCTION OpenINIFile() AS INTEGER

   DIM RAW SyntaxFile$, linein$


   SyntaxFile$ = PELLESPATH$ + "bin\addins\bcxfile.ini"
   IF NOT EXIST(SyntaxFile$) THEN
      MSGBOX "Syntax Highlighter File Not Found" & CRLF$ & SyntaxFile$, DllName$,0
      FUNCTION = FALSE
   END IF

   OPEN SyntaxFile$ FOR INPUT AS FP1

   DIM kw%, pp%, fn%, op%
   DIM kwinmax%, ppinmax%, fninmax%, opinmax%


   kwinmax% = 100
   ppinmax% = 20
   fninmax% = 20
   opinmax% = 20

   apszKeywords = calloc(kwinmax, sizeof(PCHAR))
   apszPrePro   = calloc(ppinmax, sizeof(PCHAR))
   apszFunction = calloc(fninmax, sizeof(PCHAR))
   apszOperator = calloc(opinmax, sizeof(PCHAR))


   WHILE NOT EOF(FP1)
      LINE INPUT FP1, linein$
      IF INSTR(linein$,"'") THEN linein$ = EXTRACT$(linein$,"'")

      linein$ = TRIM$(LCASE$(linein$))
      IF linein$ = "" THEN ITERATE
      IF LEFT$(linein$,4) = "rem " OR LEFT$(linein$,1) = "'" THEN ITERATE

      IF kw% THEN
         apszKeywords[kwin%] = malloc(sizeof(char)* (LEN(linein$)+1))
         apszKeywords$[kwin%] = linein$
         kwin%++
         IF kwin% = kwinmax% THEN
            kwinmax% = kwinmax% + 50
            apszKeywords = realloc(apszKeywords, kwinmax * sizeof(PCHAR))
         END IF
      END IF
      IF pp% THEN
         apszPrePro[ppin%] = malloc(sizeof(char)* (LEN(linein$)+1))
         apszPrePro$[ppin%] = linein$
         ppin%++
         IF ppin% = ppinmax% THEN
            ppinmax% = ppinmax% + 50
            apszPrePro = realloc(apszPrePro, ppinmax * sizeof(PCHAR))
         END IF
      END IF
      IF fn% THEN
         apszFunction[fnin%] = malloc(sizeof(char)* (LEN(linein$)+1))
         apszFunction$[fnin%] = linein$
         fnin%++
         IF fnin% = fninmax% THEN
            fninmax% = fninmax% + 50
            apszFunction = realloc(apszFunction, fninmax * sizeof(PCHAR))
         END IF
      END IF
      IF op% THEN
         apszOperator[opin%] = malloc(sizeof(char)* (LEN(linein$)+1))
         apszOperator$[opin%] = linein$
         opin%++
         IF opin% = opinmax% THEN
            opinmax% = opinmax% + 50
            apszOperator = realloc(apszOperator, opinmax * sizeof(PCHAR))
         END IF
      END IF

      IF linein$ = "[keyword]" THEN
         kw% = TRUE
         pp% = fn% = op% = FALSE
      ELSEIF  linein$ = "[preprocessor]" THEN
         pp% = TRUE
         kw% = fn% = op% = FALSE
      ELSEIF  linein$ = "[function]" THEN
         fn% = TRUE
         pp% = kw% = op% = FALSE
      ELSEIF  linein$ = "[operator]" THEN
         op% = TRUE
         pp% = fn% = kw% = FALSE
      ELSEIF LEFT$(linein$,1) = "[" AND RIGHT$(linein$,1) = "]" THEN
         op% = pp% = fn% = kw% = FALSE
      END IF
   WEND
   CLOSE FP1

   CONST sqsort = qsort

   sqsort(apszKeywords, kwin, sizeof(apszKeywords[0]), DynStrCompareA)
   sqsort(apszPrePro, ppin, sizeof(apszPrePro[0]), DynStrCompareA)
   sqsort(apszFunction, fnin, sizeof(apszFunction[0]), DynStrCompareA)
   sqsort(apszOperator, opin, sizeof(apszOperator[0]), DynStrCompareA)

   FUNCTION = TRUE
END FUNCTION

'***************************************************************************
'
' Function: FreeDynamicArray
'
' Purpose : Free the dynamic array in case the DLL is unloaded before exit
'
' History : Date       Reason
'           23-10-04   Created
'
'***************************************************************************

SUB FreeDynamicArray()
   DIM i
   '
   IF kwin THEN
      FOR i = 0 TO kwin%-1
         FREE apszKeywords[i]
      NEXT
   END IF
   IF apszKeywords THEN FREE apszKeywords
   '
   IF ppin THEN
      FOR i = 0 TO ppin-1
         FREE apszPrePro[i]
      NEXT
   END IF
   IF apszPrePro THEN FREE apszPrePro
   '
   IF fnin THEN
      FOR i = 0 TO fnin-1
         FREE apszFunction[i]
      NEXT
   END IF
   IF apszFunction THEN FREE apszFunction
   '
   IF opin THEN
      FOR i = 0 TO opin-1
         FREE apszOperator[i]
      NEXT
   END IF
   IF apszOperator THEN FREE apszOperator
END SUB
