// *************************************************************
//   Created with BCX -- The BASIC To C Translator (ver 5.06.194)
//  BCX (c) 1999, 2000, 2001, 2002, 2003, 2004, 2005 by Kevin Diggins
// *************************************************************
//     Translated for compiling with a C Compiler
// *************************************************************
#define WIN32_LEAN_AND_MEAN // limits reading seldom used header files
#include <windows.h>    // Win32 Header File 
#include <windowsx.h>   // Win32 Header File 
#include <commctrl.h>   // Win32 Header File 
#include <mmsystem.h>   // Win32 Header File 
#include <shellapi.h>   // Win32 Header File 
#include <shlobj.h>     // Win32 Header File 
#include <richedit.h>   // Win32 Header File 
#include <wchar.h>      // Win32 Header File 
#include <objbase.h>    // Win32 Header File 
#include <ocidl.h>      // Win32 Header File 
#include <winuser.h>    // Win32 Header File 
#include <olectl.h>     // Win32 Header File 
#include <oaidl.h>      // Win32 Header File 
#include <ole2.h>       // Win32 Header File 
#include <oleauto.h>    // Win32 Header File 
#include <conio.h>
#include <direct.h>
#include <ctype.h>
#include <io.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include <setjmp.h>
#include <time.h>
#include <stdarg.h>
#include <process.h>


// ***************************************************
// Compiler Defines
// ***************************************************

// C++
#if defined( __cplusplus )
  #define overloaded
  #define C_EXPORT EXTERN_C __declspec(dllexport)
  #define C_IMPORT EXTERN_C __declspec(dllimport)
#else
  #define C_EXPORT __declspec(dllexport)
  #define C_IMPORT __declspec(dllimport)
#endif

// Open Watcom defs
#if defined( __WATCOM_CPLUSPLUS__ )
  #define atanl atan
  #define sinl  sin
  #define cosl  cos
  #define tanl  tan
  #define asinl asin
  #define acosl acos
  #define log10l log10
  #define logl   log
  #define _fcloseall fcloseall
#endif

// Borland C++ 5.5.1 defs - bcc32.exe
#if defined( __BCPLUSPLUS__ )
  // ===== Borland Libraries ==========
  #include <dos.h>
  #pragma comment(lib,"import32.lib")
  #pragma comment(lib,"cw32.lib")
  // ==================================
#endif

// Microsoft VC++
#ifndef DECLSPEC_UUID
  #if (_MSC_VER >= 1100) && defined ( __cplusplus )
    #define DECLSPEC_UUID(x)    __declspec(uuid(x))
  #else
    #define DECLSPEC_UUID(x)
  #endif
#endif

#include <addin.h>
#include <wizard.h>
#include <assert.h>
#include "bcxfile.h"
// ***************************************************

#define DEFINE_COLOR(pos,color) \
assert((pos) >= 0 && (pos) < cchText); \
if (aPoints != NULL){ \
if (*pcPoints == 0 || aPoints[(*pcPoints)-1].iChar <= (pos)){ \
aPoints[(*pcPoints)].iChar = (pos);\
aPoints[(*pcPoints)].iColor = (color);\
(*pcPoints)++; \
} \
}


#if !defined( __LCC__ )
// *************************************************
// Instruct Linker to Search Object/Import Libraries
// *************************************************
#pragma comment(lib,"kernel32.lib")
#pragma comment(lib,"user32.lib")
#pragma comment(lib,"gdi32.lib")
#pragma comment(lib,"comctl32.lib")
#pragma comment(lib,"advapi32.lib")
#pragma comment(lib,"winspool.lib")
#pragma comment(lib,"shell32.lib")
#pragma comment(lib,"ole32.lib")
#pragma comment(lib,"oleaut32.lib")
#pragma comment(lib,"uuid.lib")
#pragma comment(lib,"odbc32.lib")
#pragma comment(lib,"odbccp32.lib")
#pragma comment(lib,"winmm.lib")
#pragma comment(lib,"comdlg32.lib")
#pragma comment(lib,"imagehlp.lib")
#pragma comment(lib,"version.lib")
#else
#pragma lib <winspool.lib>
#pragma lib <shell32.lib>
#pragma lib <ole32.lib>
#pragma lib <oleaut32.lib>
#pragma lib <uuid.lib>
#pragma lib <odbc32.lib>
#pragma lib <odbccp32.lib>
#pragma lib <winmm.lib>
#pragma lib <imagehlp.lib>
#pragma lib <version.lib>
// *************************************************
// End of Object/Import Libraries To Search
// *************************************************
#endif
// *************************************************
//            User Defined Constants
// *************************************************

#define ID_BCX 1
#define ID_OPENBCX 2
#define DllName "BCX Helper DLL"
#define FLAG_COMMENT 0x01
#define FLAG_STRING 0x02
#define FLAG_MLCOMMENT 0x04
#define FLAG_UNUSED2 0x08
#define FLAG_UNUSED3 0x10
#define FLAG_UNUSED4 0x20
#define FLAG_UNUSED5 0x40
#define FLAG_UNUSED6 0x80
#define ADDINAPI_BOOL ADDINAPI BOOL 
#define ADDINAPI_void ADDINAPI void 
#define int_cdecl int __cdecl
#define cvoid const void 
#define sqsort qsort 

// *************************************************
//                System Variables
// *************************************************

char    NUL [1]={0};     // Null
char    CRLF[3]={13,10,0}; // Carr Rtn & Line Feed

// *************************************************
//            User Global Variables
// *************************************************

static LPSTR   *apszKeywords;
static PCHAR   *apszPrePro;
static PCHAR   *apszFunction;
static PCHAR   *apszOperator;
static int     kwin;
static int     ppin;
static int     fnin;
static int     opin;
static HANDLE  g_hmod;
static HANDLE  g_hwndMain;
static HANDLE  g_hwndPrj;
static int     g_fType;
static BOOL   InFunction;
static FILE*  FP1;



// *************************************************
//               Standard Macros
// *************************************************

#define BAND &


// *************************************************
//               Standard Prototypes
// *************************************************

int     str_cmp(char*, char*);
int     EoF (FILE*);
char*   BCX_TmpStr(size_t);
char*   lcase (char*);
char*   mid (char*, int, int=-1);
char*   trim (char*);
char*   left (char*,int);
char*   right (char*,int);
char*   extract (char*,char*);
char*   BcxPath (void);
char*   PellesPath (void);
char*   RegString (HKEY,char*,char*);
char*   join (int, ... );
char*   enc (char*, int=0, int=0);
int     InstrRev (char*,char*,int=0);
int     instr(char*,char*,int=0,int=0);
char    *_stristr_(char*,char*);
BOOL    Exist   (char*);
BOOL    Exist_A (char*);
BOOL    Exist_B (char*);

// *************************************************
//               User Prototypes
// *************************************************

BOOL    CALLBACK DllMain (HANDLE, DWORD, LPVOID);
ADDINAPI_BOOL CALLBACK AddInMain (HWND, ADDIN_EVENT);
USHORT  Parser (USHORT, PCTSTR, int, ADDIN_PARSE_POINT* , PINT);
BOOL    IsKeyword (PTSTR* , int, PCTSTR, int);
BOOL    IsNumber (PCTSTR, int);
ADDINAPI_void CALLBACK AddInCommandEx (int, LPCVOID);
void    CloseOpenWindows (char *);
BOOL    CALLBACK CloseWindowCallback (HWND, LPVOID);
int_cdecl DynStrCompareA (cvoid* , cvoid* );
int     OpenINIFile (void);
void    FreeDynamicArray (void);

// *************************************************
//                  Main Program
// *************************************************


// *************************************************
//                 Runtime Functions
// *************************************************

char *BCX_TmpStr (size_t Bites)
{
  static int   StrCnt;
  static char *StrFunc[ 512];
  StrCnt=(++StrCnt & 511);
  StrFunc[StrCnt]=(char*)realloc(StrFunc[StrCnt],Bites + 128);
  return (char*)memset(StrFunc[StrCnt],0,Bites+128);
}


int str_cmp (char *a, char *b)
{
  register int counter=0;
  while(1)
   {
    if((a[counter]^b[counter]))
     {
      if((UINT) a[counter]>= (UINT) b[counter])
      return  1;
      return -1;
     }
    if(!a[counter]) return 0;
    counter++;
   }
#if !defined( __cplusplus )
 return 0;
#endif
}


int EoF (FILE* stream)
{
  register int c, status = ((c = fgetc(stream)) == EOF);
  ungetc(c,stream);
  return status;
}


char *left (char *S, int length)
{
  register int tmplen = strlen(S);
  char *strtmp = BCX_TmpStr(tmplen);
  strcpy (strtmp,S);
  if(length>tmplen)
    strtmp[tmplen] = 0;
  else
    strtmp[length] = 0;
  return strtmp;
}


char *right (char *S, int length)
{
  int tmplen = strlen(S);
  char *BCX_RetStr = BCX_TmpStr(tmplen);
  tmplen -= length;
  if (tmplen<0) tmplen = 0;
  return strcpy(BCX_RetStr, S + tmplen);
}


char *mid (char *S, int start, int length)
{
  register int tmplen = strlen(S);
  char *strtmp;
  if(start>tmplen||start<1) return BCX_TmpStr(1);
  if (length < 0) length = tmplen - start + 1;
  strtmp = BCX_TmpStr(length);
  strncpy(strtmp,&S[start-1],length);
  strtmp[length] = 0;
  return strtmp;
}


char *trim (char *S)
{
  register int i = strlen(S);
  char *strtmp = BCX_TmpStr(i);
  strcpy(strtmp,S);
  while(i--)
  {
   if(S[i]!=0  &&
      S[i]!=9  &&
      S[i]!=10 &&
      S[i]!=11 &&
      S[i]!=13 &&
      S[i]!=32) break;
  }
  strtmp[++i]=0;
  while(*strtmp=='\x09' ||
        *strtmp=='\x0A' ||
        *strtmp=='\x0B' ||
        *strtmp=='\x0D' ||
        *strtmp=='\x20' )
    strtmp++;
  return strtmp;
}


char *extract (char *mane, char *match)
{
  register char *a;
  register char *strtmp = BCX_TmpStr(strlen(mane));
  strcpy(strtmp,mane);
  a=strstr(mane,match);
  if(a) strtmp[a-mane]=0;
  return strtmp;
}


char *lcase (char *S)
{
  register char *strtmp = BCX_TmpStr(strlen(S));
  return strlwr(strcpy(strtmp,S));
}


char *enc (char *A, int L, int R)
{
  register char *BCX_RetStr = BCX_TmpStr(strlen(A)+3);
  if(L==0) L=34;
  if(R==0) R=L;
  sprintf(BCX_RetStr,"%c%s%c%s",L,A,R,"");
  return BCX_RetStr;
}


char * join(int n, ...)
{
  register int i = n, tmplen = 0;
  register char *s_;
  register char *strtmp;
  va_list marker;
  va_start(marker, n); // Initialize variable arguments
  while(i-- > 0)
  {
    s_ = va_arg(marker, char *);
    tmplen += strlen(s_);
  }
  strtmp = BCX_TmpStr(tmplen);
  va_end(marker); // Reset variable arguments
  i = n;
  va_start(marker, n); // Initialize variable arguments
  while(i-- > 0)
  {
    s_ = va_arg(marker, char *);
    strcat(strtmp, s_);
  }
  va_end(marker); // Reset variable arguments
  return strtmp;
}


int InstrRev (char *s, char *p, int os)
{
 register int sl, pl, ox;
 if (!s || !p)
   return 0;
 sl = (int) strlen(s);
 pl = (int) strlen(p);
 if (pl == 0 || (ox = sl - pl) < 0)
   return 0;
 if (os <= 0 || os > ox)
   os = ox + 1;
 for (; os; os--)
   if (strncmp(s + os - 1, p, (size_t) pl) == 0)
     return os;
 return 0;
}


int instr(char* mane,char* match,int offset,int sensflag)
{
  register char *s;
  if (!mane || !match || ! *match || offset>(int)strlen(mane)) return 0;
  if (sensflag)
    s = _stristr_(offset>0 ? mane+offset-1 : mane,match);
  else
    s = strstr (offset>0 ? mane+offset-1 : mane,match);
  return s ? (int)(s-mane)+1 : 0;
}


char *_stristr_(char *String, char *Pattern)
{
  register char *pptr, *sptr, *start;
  register UINT  slen, plen;
  for (start = (char *)String,
    pptr  = (char *)Pattern,
    slen  = strlen(String),
    plen  = strlen(Pattern);
    slen >= plen;
    start++, slen--)
    {
     while (toupper(*start) != toupper(*Pattern))
       {
        start++;
        slen--;
        if (slen < plen)
        return(0);
       }
      sptr = start;
      pptr = (char *)Pattern;
      while (toupper(*sptr) == toupper(*pptr))
        {
         sptr++;
         pptr++;
         if (!*pptr) return (start);
        }
    }
 return(0);
}


BOOL Exist (char *szFilePath)
{
  if(instr(szFilePath,"*")||instr(szFilePath,"?"))
  return Exist_A (szFilePath);
  return Exist_B (szFilePath);
}

BOOL Exist_A (char *szFilePath)
{
  WIN32_FIND_DATA W32FindData;
  HANDLE rc;
  rc = FindFirstFile(szFilePath, &W32FindData);
  if(rc == INVALID_HANDLE_VALUE) return FALSE;
  FindClose(rc);
  return TRUE;
}

BOOL Exist_B (char *szFilePath)
{
  DWORD ret;
  ret = GetFileAttributes(szFilePath);
  if (ret != 0xffffffff) return TRUE;
  return FALSE;
}


char *BcxPath (void)
{
  char *BCX_RegPath=BCX_TmpStr(2048);
  strcpy(BCX_RegPath,RegString
  (HKEY_LOCAL_MACHINE,"Software\\Bcx-32\\Bcx\\Settings","Path"));
  if(BCX_RegPath[0]==0)
    return strcpy(BCX_RegPath,"Not Found");
    return BCX_RegPath;
}


char *PellesPath (void)
{
  char *BCX_RetStr={0};
  static char Pelles_Reg[2048];
  static char Pelles_RegPath[2048];
  strcpy(Pelles_Reg,"Software\\Pelle Orinius\\PellesC\\Directories\\");
  strcpy(Pelles_RegPath,(char*)RegString(HKEY_LOCAL_MACHINE,Pelles_Reg,"PathDirs"));
  if(Pelles_RegPath[0]==0)
    {
      strcpy(Pelles_RegPath,(char*)RegString(HKEY_CURRENT_USER,Pelles_Reg,"PathDirs"));
    }
  if(strcmp(Pelles_RegPath,"")!=0)
    {
      BCX_RetStr=BCX_TmpStr(256);
      return strcpy(BCX_RetStr,(char*)left(Pelles_RegPath,InstrRev(Pelles_RegPath,"\\")));
    }
 else
    {
      BCX_RetStr=BCX_TmpStr(strlen(Pelles_RegPath));
      return strcpy(BCX_RetStr,Pelles_RegPath);
    }
}


char *RegString (HKEY hKey, char *RegPath, char *SubKey)
{
  char *Result=BCX_TmpStr(2048);
  int BufferLen=2048;
  if(!RegOpenKeyEx(hKey,RegPath,0,KEY_QUERY_VALUE,&hKey))
    {
   RegQueryValueEx(hKey,SubKey,0,0,(LPBYTE)Result,(LPDWORD)&BufferLen);
    }
  RegCloseKey(hKey);
  return Result;
}



// ************************************
//       User Subs and Functions
// ************************************


BOOL CALLBACK DllMain (HANDLE hDLL, DWORD dwReason, LPVOID lpReserved)
{
  while(1)
  {
    if((dwReason)==DLL_PROCESS_ATTACH)
      {
        g_hmod=hDLL;
        return TRUE;
      }
    if((dwReason)==DLL_PROCESS_DETACH)
      {
        return TRUE;
      }
    break;
  }
  return TRUE;
}


ADDINAPI_BOOL CALLBACK AddInMain (HWND hwnd, ADDIN_EVENT eEvent)
{
  while(1)
  {
    if((eEvent)==AIE_APP_CREATE)
      {
        ADDIN_ADD_FILE_TYPE  AddFile={0};
        ADDIN_ADD_COMMAND  AddCmd={0};
        g_hwndMain=hwnd;
        if(!OpenINIFile())
          {
            return FALSE;
          }
        AddFile.cbSize=sizeof(AddFile);
        AddFile.pszDescription="BCX Source file";
        AddFile.pszExtension="bas";
        AddFile.pfnParser=Parser;
        static char temp[2048];
        memset(&temp,0,sizeof(temp));
        GetShortPathName(BcxPath(),temp,2048);
        strcpy(temp, join(3,temp,"BC ","$*.bas -p -i\0$(CC) -c $*.c\0"));
        AddFile.pszShells=temp;
        if(!AddIn_AddFileType(hwnd,&AddFile))
          {
            return FALSE;
          }
        AddCmd.cbSize=sizeof(AddCmd);
        AddCmd.pszText="BCX build";
        AddCmd.hIcon=LoadImage(g_hmod,MAKEINTRESOURCE(IDR_BCXICON),IMAGE_ICON,16,16,LR_DEFAULTCOLOR|LR_SHARED);
        AddCmd.id=ID_BCX;
        AddCmd.idMenu=AIM_MENU_NOTHING;
        if(!AddIn_AddCommand(hwnd,&AddCmd))
          {
            return FALSE;
          }
        AddCmd.pszText="Find BCX file";
        AddCmd.id=ID_OPENBCX;
        AddCmd.hIcon=(HICON)NUL;
        AddCmd.idMenu=AIM_MENU_PROJECT_CONTEXT;
        if(!AddIn_AddCommand(hwnd,&AddCmd))
          {
            return FALSE;
          }
        return TRUE;
      }
    if((eEvent)==AIE_PRJ_CREATE)
      {
        g_hwndPrj=hwnd;
        return TRUE;
      }
    if((eEvent)==AIE_PRJ_DESTROY)
      {
        g_hwndPrj=NULL;
        return TRUE;
      }
    if((eEvent)==AIE_APP_DESTROY)
      {
        FreeDynamicArray();
        AddIn_RemoveCommand(hwnd,ID_OPENBCX);
        AddIn_RemoveCommand(hwnd,ID_BCX);
        return TRUE;
      }
    break;
  }
  return TRUE;
}


USHORT Parser (USHORT usCookie, PCTSTR pszText, int cchText, ADDIN_PARSE_POINT* aPoints, PINT pcPoints)
{
  BYTE  cFoldLevel;
  int  iRedefine=0;
  int  iIdentBegin=-1;
  BOOL  fSeenEnd=FALSE;
  BOOL  fSeenExit=FALSE;
  BOOL  fSeenDeclare=FALSE;
  int  i;
  if(cchText==0)
    {
      return usCookie;
    }
  cFoldLevel=ADDIN_GET_COOKIE_LEVEL(usCookie);
  usCookie=ADDIN_GET_COOKIE_FLAGS(usCookie);
  i=0;
  while(TRUE)
    {
      if(iRedefine>=0)
        {
          if(usCookie BAND FLAG_COMMENT)
            {
              DEFINE_COLOR(iRedefine,ADDIN_COLOR_COMMENT);
            }
          else if(usCookie BAND (FLAG_STRING))
            {
              DEFINE_COLOR(iRedefine,ADDIN_COLOR_STRING);
            }
          else
            {
              DEFINE_COLOR(iRedefine,ADDIN_COLOR_TEXT);
            }
          iRedefine=-1;
        }
      if(i==cchText)
        {
          break;
        }
      if(usCookie BAND FLAG_COMMENT)
        {
          DEFINE_COLOR(i,ADDIN_COLOR_COMMENT);
          usCookie|=FLAG_COMMENT;
          break;
        }
      if(usCookie BAND FLAG_MLCOMMENT)
        {
          DEFINE_COLOR(i,ADDIN_COLOR_COMMENT);
          if(_strnicmp("$comment",pszText+i,8)==0)
            {
              usCookie=usCookie BAND ~FLAG_MLCOMMENT;
            }
          i++;
          continue;
        }
      if(usCookie BAND FLAG_STRING)
        {
          if(pszText[i]==34)
            {
              usCookie&=~FLAG_STRING;
              iRedefine=i+1;
            }
          i++;
          continue;
        }
      if(pszText[i]==39)
        {
          DEFINE_COLOR(i,ADDIN_COLOR_COMMENT);
          usCookie|=FLAG_COMMENT;
          break;
        }
      if(_strnicmp("$comment",pszText+i,8)==0)
        {
          DEFINE_COLOR(i,ADDIN_COLOR_COMMENT);
          usCookie|=FLAG_MLCOMMENT;
          break;
        }
      if(pszText[i]==34)
        {
          DEFINE_COLOR(i,ADDIN_COLOR_STRING);
          usCookie|=FLAG_STRING;
          i++;
          continue;
        }
      if(isalnum(pszText[i])||pszText[i]==35||pszText[i]==36||pszText[i]==95)
        {
          if(iIdentBegin==-1)
            {
              iIdentBegin=i;
            }
        }
      else
        {
          if(iIdentBegin>=0)
            {
              if(IsKeyword(apszKeywords,kwin,pszText+iIdentBegin,i-iIdentBegin))
                {
                  DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_KEYWORD);
                  if(!fSeenExit&&!fSeenDeclare&&_strnicmp("function",pszText+iIdentBegin,i-iIdentBegin)==0)
                    {
                      if(fSeenEnd&&cFoldLevel>0)
                        {
                          cFoldLevel--;
                          InFunction=FALSE;
                        }
                      else if(!fSeenEnd&&cFoldLevel<255)
                        {
                          if(!InFunction)
                            {
                              cFoldLevel++;
                              InFunction=TRUE;
                            }
                        }
                    }
                  else if(!fSeenExit&&_strnicmp("sub",pszText+iIdentBegin,i-iIdentBegin)==0)
                    {
                      if(fSeenEnd&&cFoldLevel>0)
                        {
                          cFoldLevel--;
                        }
                      else if(!fSeenEnd&&cFoldLevel<255)
                        {
                          cFoldLevel++;
                        }
                    }
                  else
                    {
                      if(_strnicmp("end",pszText+iIdentBegin,i-iIdentBegin)==0)
                        {
                          fSeenEnd=TRUE;
                        }
                      else
                        {
                          fSeenEnd=FALSE;
                        }
                      if(_strnicmp("exit",pszText+iIdentBegin,i-iIdentBegin)==0)
                        {
                          fSeenExit=TRUE;
                        }
                      else
                        {
                          fSeenExit=FALSE;
                        }
                      if(_strnicmp("declare",pszText+iIdentBegin,i-iIdentBegin)==0)
                        {
                          fSeenDeclare=TRUE;
                        }
                      else
                        {
                          fSeenDeclare=FALSE;
                        }
                    }
                }
              else if(IsNumber(pszText+iIdentBegin,i-iIdentBegin))
                {
                  DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_NUMBER);
                }
              else if(IsKeyword(apszPrePro,ppin,pszText+iIdentBegin,i-iIdentBegin))
                {
                  DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_PREPROCESSOR);
                }
              else if(IsKeyword(apszFunction,fnin,pszText+iIdentBegin,i-iIdentBegin))
                {
                  DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_FUNCTION);
                }
              else if(IsKeyword(apszOperator,opin,pszText+iIdentBegin,i-iIdentBegin))
                {
                  DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_OPERATOR);
                }
              iRedefine=i;
              iIdentBegin=-1;
            }
        }
      i++;
    }
  if(iIdentBegin>=0)
    {
      if(IsKeyword(apszKeywords,kwin,pszText+iIdentBegin,i-iIdentBegin))
        {
          DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_KEYWORD);
          if(!fSeenExit&&!fSeenDeclare&&_strnicmp("function",pszText+iIdentBegin,i-iIdentBegin)==0)
            {
              if(fSeenEnd&&cFoldLevel>0)
                {
                  cFoldLevel--;
                }
              else if(!fSeenEnd&&cFoldLevel<255)
                {
                  cFoldLevel++;
                }
            }
          else if(!fSeenExit&&_strnicmp("sub",pszText+iIdentBegin,i-iIdentBegin)==0)
            {
              if(fSeenEnd&&cFoldLevel>0)
                {
                  cFoldLevel--;
                }
              else if(!fSeenEnd&&cFoldLevel<255)
                {
                  cFoldLevel++;
                }
            }
        }
      else if(IsNumber(pszText+iIdentBegin,i-iIdentBegin))
        {
          DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_NUMBER);
        }
      else if(IsKeyword(apszPrePro,ppin,pszText+iIdentBegin,i-iIdentBegin))
        {
          DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_PREPROCESSOR);
        }
      else if(IsKeyword(apszFunction,fnin,pszText+iIdentBegin,i-iIdentBegin))
        {
          DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_FUNCTION);
        }
      else if(IsKeyword(apszOperator,opin,pszText+iIdentBegin,i-iIdentBegin))
        {
          DEFINE_COLOR(iIdentBegin,ADDIN_COLOR_OPERATOR);
        }
    }
  return ADDIN_MAKE_COOKIE(usCookie BAND ~FLAG_COMMENT,cFoldLevel);
}


BOOL IsKeyword (PTSTR* anyKeywords, int cKeywords, PCTSTR pszText, int cchText)
{
  int  lo=0;
  int  hi=cKeywords-1;
  while(hi>=lo)
    {
      int  tthis;
      tthis=(lo+hi)/2;
      int  cond;
      cond=_strnicmp(anyKeywords[tthis],pszText,cchText);
      if(cond>0)
        {
          hi=tthis-1;
        }
      else if(cond<0)
        {
          lo=tthis+1;
        }
      else if(anyKeywords[tthis][cchText]==0)
        {
          return TRUE;
        }
      else if(IsKeyword(anyKeywords+lo,tthis-lo,pszText,cchText))
        {
          return TRUE;
        }
      else if(IsKeyword(anyKeywords+tthis+1,hi-tthis,pszText,cchText))
        {
          return TRUE;
        }
      else
        {
          break;
        }
    }
  return FALSE;
}


BOOL IsNumber (PCTSTR pszText, int cchText)
{
  int  i=0;
  while(i<cchText)
    {
      if(!isdigit(pszText[i]))
        {
          return FALSE;
        }
      i++;
    }
  return TRUE;
}


ADDINAPI_void CALLBACK AddInCommandEx (int idCmd, LPCVOID pcvData)
{
  if(idCmd==ID_BCX)
    {
      HWND  hwndDoc=NULL;
      ADDIN_DOCUMENT_INFO  DocInfo={0};
      static char mbmsg[2048];
      memset(&mbmsg,0,sizeof(mbmsg));
      static char bcxbuf[2048];
      memset(&bcxbuf,0,sizeof(bcxbuf));
      static char cbuf[2048];
      memset(&cbuf,0,sizeof(cbuf));
      static char ccbuf[2048];
      memset(&ccbuf,0,sizeof(ccbuf));
      static char temp[2048];
      memset(&temp,0,sizeof(temp));
      char SyntaxFile[2048];
      DocInfo.cbSize=sizeof(DocInfo);
      hwndDoc=AddIn_GetActiveDocument(g_hwndMain);
      if(hwndDoc==NULL)
        {
          MessageBox (GetActiveWindow(),"The BCX Source file must be Open in the POIDE",DllName,0);
          return;
        }
      AddIn_GetDocumentInfo(hwndDoc,&DocInfo);
      if(!*DocInfo.szFilename)
        {
          strcpy(mbmsg, join(3,"Cannot find BCX source file. Make sure it is open in POIDE,",CRLF,"and has a valid filename"));
          MessageBox (GetActiveWindow(),mbmsg,DllName,0);
          return;
        }
      strcpy(bcxbuf,DocInfo.szFilename);
      strcpy(bcxbuf, join(2,lcase(extract(bcxbuf,".")),".bas"));
      strcpy(cbuf, join(2,lcase(extract(bcxbuf,".")),".c"));
      if(!Exist(bcxbuf))
        {
          strcpy(mbmsg, join(3,"Cannot find BCX source file.",CRLF,bcxbuf));
          MessageBox (GetActiveWindow(),mbmsg,DllName,0);
          return;
        }
      strcpy(ccbuf,cbuf);
      CloseOpenWindows(ccbuf);
      AddIn_SendIDECommand(g_hwndMain,AIC_FILE_SAVEALL);
      GetShortPathName(BcxPath(),temp,2048);
      strcpy(bcxbuf, join(4,temp,"BC ",enc(bcxbuf)," -p -i"));
      system(bcxbuf);
      if(Exist(cbuf))
        {
          if(g_hwndPrj==NULL)
            {
              if(g_fType!=-1)
                {
                  strcpy(SyntaxFile, join(2,PellesPath(),"bin\\addins\\bcxfile.ini"));
                  if(Exist(SyntaxFile))
                    {
                      WritePrivateProfileString("C_FILE","Path",cbuf,SyntaxFile);
                      AddIn_SendIDECommand(g_hwndMain,AIC_FILE_NEWPROJECT);
                      WritePrivateProfileString("C_FILE","Path","",SyntaxFile);
                    }
                }
            }
          AddIn_SendIDECommand(g_hwndMain,AIC_PROJ_BUILDALL);
          if(ccbuf[0]==0)
            {
              AddIn_OpenDocument(g_hwndMain,AID_SOURCE,cbuf);
              AddIn_SendIDECommand(g_hwndMain,AIC_MISC_NEXTWINDOW);
            }
        }
      else
        {
          MessageBox (GetActiveWindow(),"Build failed",DllName,0);
        }
    }
  if(idCmd==ID_OPENBCX)
    {
      if(!IsBadStringPtr(pcvData,260))
        {
          char bcxbuf[2048];
          strcpy(bcxbuf,pcvData);
          strcpy(bcxbuf, join(2,extract(bcxbuf,"."),".bas"));
          if(Exist(bcxbuf))
            {
              AddIn_OpenDocument(g_hwndMain,AID_UNKNOWN,bcxbuf);
            }
        }
    }
}


void CloseOpenWindows (char *filein)
{
  ADDIN_ENUM_DOCUMENTS  mEnum={0};
  mEnum.cbSize=sizeof(mEnum);
  mEnum.pfnCallback=CloseWindowCallback;
  mEnum.pvData=filein;
  AddIn_EnumDocuments(g_hwndMain,&mEnum);
}


BOOL CALLBACK CloseWindowCallback (HWND hwndDoc, LPVOID pvData)
{
  ADDIN_DOCUMENT_INFO  DocInfo={0};
  DocInfo.cbSize=sizeof(DocInfo);
  LPSTR  lpvData;
  lpvData=(LPSTR)pvData;
  if(hwndDoc!=NULL)
    {
      if(AddIn_GetDocumentInfo(hwndDoc,&DocInfo))
        {
          if(*DocInfo.szFilename)
            {
              if(str_cmp(lpvData,lcase(DocInfo.szFilename))==0)
                {
                  AddIn_CloseDocument(hwndDoc);
                  *lpvData=0;
                }
            }
        }
    }
  return TRUE;
}


int_cdecl DynStrCompareA (cvoid* arg1, cvoid* arg2)
{
  PCHAR  v1;
  PCHAR  v2;
  int      i;
  v1=*(char**)arg1;
  v2=*(char**)arg2;
  i=lstrcmpi(v1,v2);
  return i;
}


int OpenINIFile (void)
{
  char SyntaxFile[2048];
  char linein[2048];
  strcpy(SyntaxFile, join(2,PellesPath(),"bin\\addins\\bcxfile.ini"));
  if(!Exist(SyntaxFile))
    {
      MessageBox (GetActiveWindow(),join(3,"Syntax Highlighter File Not Found",CRLF,SyntaxFile),DllName,0);
      return FALSE;
    }
  if((FP1=fopen(SyntaxFile,"r"))==0)
   {
  fprintf(stderr,"Can't open file %s\n",SyntaxFile);exit(1);
   }
  static int      kw;
  memset(&kw,0,sizeof(kw));
  static int      pp;
  memset(&pp,0,sizeof(pp));
  static int      fn;
  memset(&fn,0,sizeof(fn));
  static int      op;
  memset(&op,0,sizeof(op));
  static int      kwinmax;
  memset(&kwinmax,0,sizeof(kwinmax));
  static int      ppinmax;
  memset(&ppinmax,0,sizeof(ppinmax));
  static int      fninmax;
  memset(&fninmax,0,sizeof(fninmax));
  static int      opinmax;
  memset(&opinmax,0,sizeof(opinmax));
  kwinmax=100;
  ppinmax=20;
  fninmax=20;
  opinmax=20;
  apszKeywords=calloc(kwinmax,sizeof(PCHAR));
  apszPrePro=calloc(ppinmax,sizeof(PCHAR));
  apszFunction=calloc(fninmax,sizeof(PCHAR));
  apszOperator=calloc(opinmax,sizeof(PCHAR));
  while(!EoF(FP1))
    {
      linein[0]=0;
      fgets(linein,1048576,FP1);
      if(linein[strlen(linein)-1]==10)linein[strlen(linein)-1]=0;
      if(instr(linein,"'"))
        {
          strcpy(linein,extract(linein,"'"));
        }
      strcpy(linein,trim(lcase(linein)));
      if(linein[0]==0)
        {
          continue;
        }
      if(str_cmp(left(linein,4),"rem ")==0 || str_cmp(left(linein,1),"'")==0)
        {
          continue;
        }
      if(kw)
        {
          apszKeywords[kwin]=malloc(sizeof(char)*(strlen(linein)+1));
          strcpy(apszKeywords[kwin],linein);
          kwin++;
          if(kwin==kwinmax)
            {
              kwinmax+=50;
              apszKeywords=realloc(apszKeywords,kwinmax*sizeof(PCHAR));
            }
        }
      if(pp)
        {
          apszPrePro[ppin]=malloc(sizeof(char)*(strlen(linein)+1));
          strcpy(apszPrePro[ppin],linein);
          ppin++;
          if(ppin==ppinmax)
            {
              ppinmax+=50;
              apszPrePro=realloc(apszPrePro,ppinmax*sizeof(PCHAR));
            }
        }
      if(fn)
        {
          apszFunction[fnin]=malloc(sizeof(char)*(strlen(linein)+1));
          strcpy(apszFunction[fnin],linein);
          fnin++;
          if(fnin==fninmax)
            {
              fninmax+=50;
              apszFunction=realloc(apszFunction,fninmax*sizeof(PCHAR));
            }
        }
      if(op)
        {
          apszOperator[opin]=malloc(sizeof(char)*(strlen(linein)+1));
          strcpy(apszOperator[opin],linein);
          opin++;
          if(opin==opinmax)
            {
              opinmax+=50;
              apszOperator=realloc(apszOperator,opinmax*sizeof(PCHAR));
            }
        }
      if(str_cmp(linein,"[keyword]")==0)
        {
          kw=TRUE;
          pp=fn=op=FALSE;
        }
      else if(str_cmp(linein,"[preprocessor]")==0)
        {
          pp=TRUE;
          kw=fn=op=FALSE;
        }
      else if(str_cmp(linein,"[function]")==0)
        {
          fn=TRUE;
          pp=kw=op=FALSE;
        }
      else if(str_cmp(linein,"[operator]")==0)
        {
          op=TRUE;
          pp=fn=kw=FALSE;
        }
      else if(str_cmp(left(linein,1),"[")==0 && str_cmp(right(linein,1),"]")==0)
        {
          op=pp=fn=kw=FALSE;
        }
    }
  if(FP1)
   {
     fclose(FP1);
     FP1=NULL;
   }
  sqsort(apszKeywords,kwin,sizeof(apszKeywords[0]),DynStrCompareA);
  sqsort(apszPrePro,ppin,sizeof(apszPrePro[0]),DynStrCompareA);
  sqsort(apszFunction,fnin,sizeof(apszFunction[0]),DynStrCompareA);
  sqsort(apszOperator,opin,sizeof(apszOperator[0]),DynStrCompareA);
  return TRUE;
}


void FreeDynamicArray (void)
{
  static int      i;
  memset(&i,0,sizeof(i));
  if(kwin)
    {
      for(i=0; i<=kwin-1; i+=1)
        {
          free(apszKeywords[i]);
        }
    }
  if(apszKeywords)
    {
      free(apszKeywords);
    }
  if(ppin)
    {
      for(i=0; i<=ppin-1; i+=1)
        {
          free(apszPrePro[i]);
        }
    }
  if(apszPrePro)
    {
      free(apszPrePro);
    }
  if(fnin)
    {
      for(i=0; i<=fnin-1; i+=1)
        {
          free(apszFunction[i]);
        }
    }
  if(apszFunction)
    {
      free(apszFunction);
    }
  if(opin)
    {
      for(i=0; i<=opin-1; i+=1)
        {
          free(apszOperator[i]);
        }
    }
  if(apszOperator)
    {
      free(apszOperator);
    }
}


